/******************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtKnx module.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QKNXNETIPSERVERINFO_P_H
#define QKNXNETIPSERVERINFO_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt KNX API.  It exists for the convenience
// of the Qt KNX implementation.  This header file may change from version
// to version without notice, or even be removed.
//
// We mean it.
//

#include <QtCore/qshareddata.h>

#include <QtKnx/qtknxglobal.h>
#include <QtKnx/qknxnetipdevicedib.h>
#include <QtKnx/qknxnetiphpai.h>
#include <QtKnx/qknxnetipservicefamiliesdib.h>

#include <QtNetwork/qhostaddress.h>
#include <QtNetwork/qnetworkinterface.h>

QT_BEGIN_NAMESPACE

struct Q_KNX_EXPORT QKnxNetIpServerInfoPrivate final : public QSharedData
{
    QKnxNetIpServerInfoPrivate() = default;
    ~QKnxNetIpServerInfoPrivate() = default;

    QKnxNetIpHpai hpai;
    QKnxNetIpDib hardware;
    QKnxNetIpDib services;
    QKnxNetIpDib tunnelingInfo;
    QKnxNetIpDib extendedHardware;
    QHostAddress address;
    QNetworkInterface iinterface;
};

QT_END_NAMESPACE

#endif
